## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  message = FALSE,
  warning = FALSE
)

## -----------------------------------------------------------------------------
# read in the data
x <- c(3, 7, 11, 0, 7, 0, 4, 5, 6, 2)

# make the qqplot
qqnorm(x)
qqline(x)

## -----------------------------------------------------------------------------
n <- length(x)

# calculate the z-statistic
z_stat <- (mean(x) - 3) / (2 / sqrt(n))
z_stat

## -----------------------------------------------------------------------------
library(distributions3)

Z <- Normal(0, 1)  # make a standard normal r.v.
1 - cdf(Z, 2.37) + cdf(Z, -2.37)

## -----------------------------------------------------------------------------
1 - cdf(Z, abs(z_stat)) + cdf(Z, -abs(z_stat))

## -----------------------------------------------------------------------------
2 * cdf(Z, -2.37)

## -----------------------------------------------------------------------------
1 - cdf(Z, 2.37)

## -----------------------------------------------------------------------------
cdf(Z, 2.37)

## -----------------------------------------------------------------------------
power_lower <- (3 - 5) / (2 / sqrt(10)) + quantile(Z, 0.025)
power_upper <- (3 - 5) / (2 / sqrt(10)) + quantile(Z, 1 - 0.025)

cdf(Z, power_lower) + (1 - cdf(Z, power_upper))

## -----------------------------------------------------------------------------
(2 * (quantile(Z, 0.05 / 2) + quantile(Z, 1 - 0.9)) / (3 - 2))^2

