% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{coeffcomposite}
\alias{coeffcomposite}
\title{Parametrise two-/three- composite distribution}
\usage{
coeffcomposite(dist, coeff, startc = c(1, 1))
}
\arguments{
\item{dist}{character vector denoting the distribution of the first-, second- (and third) component respectively. If only two components are provided, the distribution reduces to the two-component distribution.}

\item{coeff}{named numeric vector holding the coefficients of the first-, second- (and third) component, predeced by coeff1., coeff2. (and  coeff3.), respectively. Coefficients for the last component do not have to be provided for the two-component distribution and will be disregarded.}

\item{startc}{starting values for the lower and upper cutoff, defaults to c(1,1).}
}
\value{
Returns a named list containing a the separate distributions and their respective coefficients, as well as the cutoffs and weights of the composite distribution
}
\description{
Determines the weights and cutoffs of the three-composite distribution numerically applying te continuity- and differentiability condition.
}
\details{
The continuity condition implies

 \deqn{ \alpha_1 = \frac{m_2(c_1) M_1(c_1)}{m_1(c_1)[M_2(c_2) - M_2(c_1)]}, \qquad \alpha_2 = \frac{m_2(c_2) [1 - M_3(c_2)]}{m_3(c_2) [M_2(c_2) - M_2(c_1)]} }

 The differentiability condition implies

 \deqn{ \frac{d}{dc_1} ln[\frac{m_1(c_1)}{m_2(c_1)}] = 0, \qquad \frac{d}{dc_2} ln[\frac{m_2(c_2)}{m_3(c_2)}] = 0 }
}
\examples{

# Three-composite distribution
dist <- c("invpareto", "lnorm", "pareto")
coeff <- c(coeff1.k = 1, coeff2.meanlog = -0.5, coeff2.sdlog = 0.5, coeff3.k = 1)
coeffcomposite(dist = dist, coeff = coeff, startc = c(1, 1))

# Two-composite distribution
dist <- c("lnorm", "pareto")
coeff <- c(coeff1.meanlog = -0.5, coeff1.sdlog = 0.5, coeff2.k = 1.5)
coeffcomposite(dist = dist, coeff = coeff, startc = c(1, 1))

dist <- c("invpareto", "lnorm")
coeff <- c(coeff1.k = 1.5, coeff2.meanlog = 2, coeff2.sdlog = 0.5)
coeffcomposite(dist = dist, coeff = coeff, startc = c(1, 1))
#'
}
