% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{composite_plt}
\alias{composite_plt}
\title{Composite coefficients after power-law transformation}
\usage{
composite_plt(dist, coeff, a = 1, b = 1, inv = FALSE)
}
\arguments{
\item{dist}{character vector denoting the distribution of the first-, second- (and third) component respectively. If only two components are provided, the distribution reduces to the two-component distribution.}

\item{coeff}{named numeric vector holding the coefficients of the first-, second- (and third) component, predeced by coeff1., coeff2. (and  coeff3.), respectively. Coefficients for the last component do not have to be provided for the two-component distribution and will be disregarded.}

\item{a, b}{constant and power of power-law transformation, defaults to 1 and 1 respectively.}

\item{inv}{logical indicating whether coefficients of the outcome variable of the power-law transformation should be returned (FALSE) or whether coefficients of the input variable being power-law transformed should be returned (TRUE). Defaults to FALSE.}
}
\value{
Returns a named list containing
\describe{
\item{coefficients}{Named vector of coefficients}
}

 ## Comparing probabilites of power-law transformed transformed variables
 dist <- c("invpareto", "lnorm", "pareto")
 coeff <- c(coeff2.meanlog = -0.5, coeff2.sdlog = 0.5, coeff3.k = 1.5, coeff1.k = 1.5)

 pcomposite(3,dist=dist,coeff=coeff)
 newcoeff = composite_plt(dist=dist,coeff=coeff,a=5,b=7)$coefficients
 pcomposite(5*3^7,dist=dist,coeff=newcoeff)

 pcomposite(5*0.9^3,dist=dist,coeff=coeff)
 newcoeff = composite_plt(dist=dist,coeff=coeff,a=5,b=3,inv=TRUE)$coefficients
 pcomposite(0.9,dist=dist,coeff=newcoeff)
}
\description{
Coefficients of a power-law transformed composite distribution
}
