% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmad.R
\name{nmad_test}
\alias{nmad_test}
\title{Normalized Absolute Deviation}
\usage{
nmad_test(
  x,
  r = 0,
  dist,
  prior = 1,
  coeff,
  stat = c("NULL", "max", "sum"),
  ...
)
}
\arguments{
\item{x}{data vector}

\item{r}{moment parameter}

\item{dist}{character vector containing distribution}

\item{prior}{named list of priors, defaults to 1}

\item{coeff}{named list of coefficients}

\item{stat}{character vector indicating which statistic should be calculated: none (NULL), the maximum deviation "max" or the sum of deviations "sum". Defaults to NULL.}

\item{...}{Additional arguments can be passed to the parametric moment call.}
}
\description{
Calculates the Normalized Absolute Deviation between the empirical moments and the moments of the provided distribution. Corresponds to the Kolmogorov-Smirnov test statistic for the zeroth moment.
}
\examples{

x <- rlnorm(1e2, meanlog = -0.5, sdlog = 0.5)
nmad_test(x = x, r = 0, dist = "lnorm", coeff = c(meanlog = -0.5, sdlog = 0.5))
nmad_test(x = x, r = 0, dist = "lnorm", coeff = c(meanlog = -0.5, sdlog = 0.5), stat = "max")
nmad_test(x = x, r = 0, dist = "lnorm", coeff = c(meanlog = -0.5, sdlog = 0.5), stat = "sum")
}
