% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto.R
\name{pareto.mle}
\alias{pareto.mle}
\title{Pareto MLE}
\usage{
pareto.mle(x, xmin = NULL, clauset = FALSE, q = 0, lower = 1e-10, upper = Inf)
}
\arguments{
\item{x}{data vector}

\item{xmin}{scale parameter of the Pareto distribution, set to min(x) if not provided}

\item{clauset}{Indicator variable for calculating the scale parameter using the clauset method, overrides provided xmin}

\item{q}{Percentage of data to search over (starting from the largest values), defaults to 0.}

\item{lower, upper}{Lower and upper bounds to the estimated shape parameter, defaults to 1e-10 and Inf respectively}
}
\value{
Returns a named list containing a
\describe{
\item{coefficients}{Named vector of coefficients}
\item{convergence}{logical indicator of convergence}
\item{n}{Length of the fitted data vector}
\item{np}{Nr. of coefficients}
}
}
\description{
Maximum likelihood estimation of the Pareto shape parameter using the Hill estimator.
}
\details{
The Hill estimator equals

 \deqn{ \hat{k} = \frac{1}{ \frac{1}{n} \sum_{i=1}^{n} log \frac{x_i}{x_{min}}} }
}
\examples{

x <- rpareto(1e3, k = 2, xmin = 2)

## Pareto fit with xmin set to the minium of the sample
pareto.mle(x = x)

## Pareto fit with xmin set to its real value
pareto.mle(x = x, xmin = 2)

## Pareto fit with xmin determined by the Clauset method
pareto.mle(x = x, clauset = TRUE)
}
