% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_fake_team.R
\name{div_fake_team}
\alias{div_fake_team}
\title{Generate randomly team-data}
\usage{
div_fake_team(
  seed = 100,
  N = 200,
  genders = c("F", "M", "O"),
  gender_prob = c(0.4, 0.58, 0.02),
  gender_salaryBias = c(1, 1.1, 1),
  jobIDs = c("sales", "analytics"),
  jobID_prob = c(0.6, 0.4),
  citizenships = c("Polish", "German", "Italian", "Indian", "Other"),
  citizenship_prob = c(0.6, 0.2, 0.1, 0.05, 0.05)
)
}
\arguments{
\item{seed}{numeric, the seed to be used in set.seed()}

\item{N}{numeric, the size of the team to be used (default = 200)}

\item{genders}{character, a vector of the genders to be used}

\item{gender_prob}{numeric, relative probabilities of the different genders to occur (must have the same length as 'genders')}

\item{gender_salaryBias}{numeric, vector with the relative salaries of the different genders (must have the same length as 'genders')}

\item{jobIDs}{character, a vector with the labels of the job categories in the team (they will appear in each grade)}

\item{jobID_prob}{numeric, a vector with the relative sizes of the different jobs in the team (must have the same length as 'jobIDs')}

\item{citizenships}{character, a vector of the citizenships to be generated}

\item{citizenship_prob}{numeric, relative probabilities of the different citizenships to occur (must have the same length as 'citizenships')}
}
\value{
dataframe (employees of the random team)
}
\description{
This function generates a data frame with data for a team (with salaries, gender, FTE, etc). This is a good start to test the package and to experiment what level of bias will be visible in the paygap for example.
}
\examples{
library(div)
d <- div_fake_team()
head(d)
diversity(table(d$gender))
}
