% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accum_sp.R
\name{accum_sp}
\alias{accum_sp}
\alias{accum_sp_entropy}
\alias{accum_sp_diversity}
\alias{accum_sp_mixing}
\alias{plot.accum_sp}
\alias{autoplot.accum_sp}
\alias{plot_map}
\title{Spatial Accumulation of Diversity}
\usage{
\method{plot}{accum_sp}(
  x,
  ...,
  q = dimnames(x$accumulation)$q[1],
  type = "l",
  main = "accumulation of ...",
  xlab = "Sample size...",
  ylab = "Diversity...",
  ylim = NULL,
  show_h0 = TRUE,
  line_width = 2,
  col_shade = "grey75",
  col_border = "red"
)

\method{autoplot}{accum_sp}(
  object,
  ...,
  q = dimnames(object$accumulation)$q[1],
  main = "Accumulation of ...",
  xlab = "Sample size...",
  ylab = "Diversity...",
  ylim = NULL,
  show_h0 = TRUE,
  col_shade = "grey75",
  col_border = "red"
)

plot_map(
  accum,
  q = as.numeric(dimnames(accum$accumulation)$q[1]),
  neighborhood = as.numeric(dplyr::last(colnames(accum$neighborhoods))),
  sigma = spatstat.explore::bw.scott(accum$X, isotropic = TRUE),
  allow_jitter = TRUE,
  weighted = FALSE,
  adjust = 1,
  dim_x = 128,
  dim_y = 128,
  main = "",
  col = grDevices::terrain.colors(256),
  contour = TRUE,
  contour_levels = 10,
  contour_col = "dark red",
  points = FALSE,
  pch = 20,
  point_col = "black",
  suppress_margins = TRUE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{an \code{accum_sp} object.}

\item{...}{Additional arguments to be passed to \link{plot}, or, in \code{plot_map()},
to \link[spatstat.explore:bw.smoothppp]{spatstat.explore::bw.smoothppp} and \link[spatstat.explore:density.ppp]{spatstat.explore::density.ppp} to
control the kernel smoothing and to \link[spatstat.geom:plot.im]{spatstat.geom::plot.im} to plot the image.}

\item{q}{a number: the order of diversity.}

\item{type}{plotting parameter. Default is "l".}

\item{main}{main title of the plot.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{ylim}{limits of the Y-axis, as a vector of two numeric values.}

\item{show_h0}{if \code{TRUE}, the values of the null hypothesis are plotted.}

\item{line_width}{width of the Diversity Accumulation Curve line.}

\item{col_shade}{The color of the shaded confidence envelope.}

\item{col_border}{The color of the borders of the confidence envelope.}

\item{object}{an \code{accum_sp} object.}

\item{accum}{an object to map.}

\item{neighborhood}{The neighborhood size, i.e. the number of neighbors or the distance to consider.}

\item{sigma}{the smoothing bandwidth.
The standard deviation of the isotropic smoothing kernel.
Either a numerical value, or a function that computes an appropriate value of sigma.}

\item{allow_jitter}{if \code{TRUE}, duplicated points are jittered to avoid their
elimination by the smoothing procedure.}

\item{weighted}{if \code{TRUE}, the weight of the points is used by the smoothing
procedure.}

\item{adjust}{force the automatically selected bandwidth to be multiplied
by \code{adjust}.
Setting it to values lower than one (1/2 for example) will sharpen the estimation.}

\item{dim_x}{the number of columns (pixels) of the resulting map, 128 by default.}

\item{dim_y}{the number of rows (pixels) of the resulting map, 128 by default.}

\item{col}{the colors of the map. See \link[spatstat.geom:plot.im]{spatstat.geom::plot.im} for details.}

\item{contour}{if \code{TRUE}, contours are added to the map.}

\item{contour_levels}{the number of levels of contours.}

\item{contour_col}{the color of the contour lines.}

\item{points}{if \code{TRUE}, the points that brought the data are added to the map.}

\item{pch}{the symbol used to represent points.}

\item{point_col}{the color of the points.
Standard base graphic arguments such as \code{main} can be used.}

\item{suppress_margins}{if \code{TRUE}, the map has reduced margins.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
\code{plot.accum_sp()} returns \code{NULL}.

\code{autoplot.accum_sp()} returns a \link[ggplot2:ggplot]{ggplot2::ggplot} object.

\code{plot_map} returns a \link[spatstat.geom:im]{spatstat.geom::im} object that can be used to produce
alternative maps.
}
\description{
A spatial accumulation is a measure of diversity with respect to the distance from individuals.
}
\details{
Objects of class \code{accum_sp} contain the value of diversity
(\code{accum_sp_diversity} objects), entropy (\code{accum_sp_entropy} objects) or
mixing (\code{accum_sp_mixing} objects) at distances from the individuals.

These objects are lists:
\itemize{
\item \code{X} contains the \link[dbmss:wmppp]{dbmss::wmppp} point pattern,
\item \code{accumulation} is a 3-dimensional array, with orders of diversity in rows,
neighborhood size (number of points or distance) in columns and a single slice
for the observed entropy, diversity or mixing.
\item \code{neighborhoods} is a similar 3-dimensional array with one slice per point
of \code{X}.
}

They can be plotted or mapped.
}
\examples{
# Generate a random community
X <- rspcommunity(1, size = 50, species_number = 10)
# Calculate the species accumulation curve
accum <- accum_sp_hill(X, orders = 0, r = c(0, 0.2), individual = TRUE)
# Plot the local richness at distance = 0.2
plot_map(accum, q = 0, neighborhood = 0.2)

}
