% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_allen.R
\name{ent_allen}
\alias{ent_allen}
\alias{ent_allen.numeric}
\alias{ent_allen.species_distribution}
\title{Allen et al.'s Phylogenetic Entropy of a Community}
\usage{
ent_allen(x, tree, ...)

\method{ent_allen}{numeric}(
  x,
  tree,
  q = 1,
  normalize = TRUE,
  prune = FALSE,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{ent_allen}{species_distribution}(
  x,
  tree,
  q = 1,
  normalize = TRUE,
  prune = FALSE,
  gamma = FALSE,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a named numeric vector (names are species names)
containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{tree}{an ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{...}{Unused.}

\item{q}{a number: the order of diversity.}

\item{normalize}{if \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{prune}{What to do when some species are in the tree but not in \code{x}?
If \code{TRUE}, the tree is pruned to keep species of \code{x} only.
The height of the tree may be changed if a pruned branch is related to the root.
If \code{FALSE} (default), the length of branches of missing species is not summed
but the height of the tree is never changed.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated entropy.
}
\description{
Estimate entropy \insertCite{Allen2009}{divent} from
abundance or probability data and a phylogenetic or functional dendrogram.
}
\details{
Estimators to deal with incomplete sampling are not implemented.
Use function \link{ent_phylo} with argument if they are needed.

The phylogenetic entropy is calculated following
\insertCite{Allen2009;textual}{divent} for order \eqn{q=1} and
\insertCite{Leinster2012;textual}{divent} for other orders.
The result is identical to the total entropy calculated by
\link{ent_phylo}.
It is much faster but no bias correction is available.

All species of the \code{species_distribution} must be found in the tips of the
\code{tree}.
}
\examples{
# entropy of each community
ent_allen(paracou_6_abd, tree = paracou_6_taxo)

# gamma entropy
ent_allen(paracou_6_abd, tree = paracou_6_taxo, gamma = TRUE)

}
\references{
\insertAllCited{}
}
