% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand.R
\name{spat.rand}
\alias{spat.rand}
\title{Standardized Effect Size (SES) for raster}
\usage{
spat.rand(
  x,
  tree,
  aleats,
  random = c("site", "species", "both", "spat"),
  cores = 1,
  filename = "",
  ...
)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence
data (0 or 1) for a set of species.}

\item{tree}{It can be a 'data.frame' with species traits or a
'phylo' with a rooted phylogenetic tree. Species names in 'tree'
and 'x' must match!}

\item{aleats}{positive integer. A positive integer indicating
how many times the calculation should be repeated.}

\item{random}{character. A character indicating the type of
randomization. The currently available randomization methods
are "spat", "site", "species" or "both" (site and species).}

\item{cores}{positive integer. If cores > 1, a 'parallel'
package cluster with that many cores is created and used.}

\item{filename}{character. Output filename.}

\item{...}{additional arguments to be passed passed down from
a calling function.}
}
\value{
SpatRaster with Mean, SD, Observed, and SES.
}
\description{
Calculates the standardized effect size for
functional and phylogenetic alpha diversity.
See \code{\link[SESraster]{bootspat_str}} and
\code{\link[SESraster]{bootspat_naive}}
}
\examples{
\donttest{
x <- terra::rast(system.file("extdata", "ref.tif",
package = "divraster"))
traits <- read.csv(system.file("extdata", "traits.csv",
package = "divraster"), row.names = 1)
tree <- ape::read.tree(system.file("extdata", "tree.tre",
package = "divraster"))
spat.rand(x, tree, 3, "site")
spat.rand(x, traits, 3, "site")
}
}
