#' Build the observation matrix for Predictive Dynamic Linear Models (pdlm)
#'
#'
#' @param x model parameters
#' @param k the dimension of observation equation
#' @param lags a nonnegative integer indicating the number of lags in latent state.
#'
#' @return A matrix with proper dimension.
#'
#' @noRd

getFF <- function(x, k, lags){
  FF <- c(x[1:(lags+2)], rep(x=x[lags+2+(1:(lags+1))], times=k-1))
  n <- 1 + k*(lags+1)
  for (i in 1:(k-1)){
    m <- 1+(lags+1)*i
    FF <- rbind(FF, c(rep(0, m), 1, rep(0, n-m-1)))
  }
  return(FF)}
