% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{construct_cached_file_path}
\alias{construct_cached_file_path}
\title{Construct Cache Path}
\usage{
construct_cached_file_path(source_path, appname, extension = "")
}
\arguments{
\item{source_path}{Character scalar; the full path to the source file.}

\item{appname}{Character; the name of the application that will "own" the
cache, such as the name of a package.}

\item{extension}{Character scalar; an optional filename extension.}
}
\value{
The full path to the processed version of source_path in the app's
cache directory.
}
\description{
Construct the full path to the cached version of a file within a particular
app's cache, using the source path of the file to make sure the cache
filename is unique.
}
\examples{
construct_cached_file_path(
  source_path = "my/file.txt",
  appname = "dlr",
  extension = "rds"
)
}
