% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_functions.R
\name{.process_and_write}
\alias{.process_and_write}
\title{Process and Write a File}
\usage{
.process_and_write(
  source_path,
  target_path,
  process_f,
  process_args,
  write_f,
  write_args
)
}
\arguments{
\item{source_path}{Character scalar; the path to the raw file. Paths starting
with \code{http://}, \code{http://}, \code{http://}, or \code{http://} will
be downloaded to a temp file if the processed version is not already
available.}

\item{target_path}{Character scalar; the path where the processed version of
the file should be stored.}

\item{process_f}{A function or one-sided formula to use to process the source
file. \code{source_path} will be passed as the first argument to this
function. Defaults to \code{read_f}.}

\item{process_args}{An optional list of additional arguments to
\code{process_f}.}

\item{write_f}{A function or one-sided formula to use to save the processed
file. The processed object will be passed as the first argument to this
function, and \code{target_path} will be passed as the second argument.
Defaults to \code{\link[base]{saveRDS}}.}

\item{write_args}{An optional list of additional arguments to \code{write_f}.}
}
\value{
The processed object.
}
\description{
Process and Write a File
}
\keyword{internal}
