% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gdmf.r
\name{GdmFull}
\alias{GdmFull}
\title{Global Distance Metric Learning}
\usage{
GdmFull(data, simi, dism, maxiter = 100)
}
\arguments{
\item{data}{\code{n * d} data matrix. \code{n} is the number of data points,
\code{d} is the dimension of the data.
Each data point is a row in the matrix.}

\item{simi}{\code{n * 2} matrix describing the similar constrains.
Each row of matrix is serial number of a similar pair in the original data.
   For example, pair(1, 3) represents the first observation is similar the 3th observation in the original data.}

\item{dism}{\code{n * 2} matrix describing the dissimilar constrains as \code{simi}.
Each row of matrix is serial number of a dissimilar pair in the original data.}

\item{maxiter}{numeric, the number of iteration.}
}
\value{
list of the GdmDiag results:
\item{newData}{GdmDiag transformed data}
\item{fullA}{suggested Mahalanobis matrix}
\item{dmlA}{matrix to transform data, square root of diagonalA }
\item{converged}{whether the iteration-projection optimization is converged or not}

For every two original data points (x1, x2) in newData (y1, y2):

\eqn{(x2 - x1)' * A * (x2 - x1) = || (x2 - x1) * B ||^2 = || y2 - y1 ||^2}
}
\description{
Performs Global Distance Metric Learning (GDM) on the given data, learning a full matrix.
}
\details{
Put GdmFull function details here.
}
\note{
Be sure to check whether the dimension of original data and constrains' format are valid for the function.
}
\examples{
\dontrun{
set.seed(123)
library(MASS)
library(scatterplot3d)

# generate simulated Gaussian data
k = 100
m <- matrix(c(1, 0.5, 1, 0.5, 2, -1, 1, -1, 3), nrow =3, byrow = T)
x1 <- mvrnorm(k, mu = c(1, 1, 1), Sigma = m)
x2 <- mvrnorm(k, mu = c(-1, 0, 0), Sigma = m)
data <- rbind(x1, x2)

# define similar constrains
simi <- rbind(t(combn(1:k, 2)), t(combn((k+1):(2*k), 2)))

temp <-  as.data.frame(t(simi))
tol <- as.data.frame(combn(1:(2*k), 2))

# define disimilar constrains
dism <- t(as.matrix(tol[!tol \%in\% simi]))

# transform data using GdmFull
result <- GdmFull(data, simi, dism)
newData <- result$newData
# plot original data
color <- gl(2, k, labels = c("red", "blue"))
par(mfrow = c(2, 1), mar = rep(0, 4) + 0.1)
scatterplot3d(data, color = color, cex.symbols = 0.6,
			  xlim = range(data[, 1], newData[, 1]),
			  ylim = range(data[, 2], newData[, 2]),
			  zlim = range(data[, 3], newData[, 3]),
			  main = "Original Data")
# plot GdmFull transformed data
scatterplot3d(newData, color = color, cex.symbols = 0.6,
			  xlim = range(data[, 1], newData[, 1]),
			  ylim = range(data[, 2], newData[, 2]),
			  zlim = range(data[, 3], newData[, 3]),
			  main = "Transformed Data")
}
}
\author{
Gao Tao <\url{http://www.gaotao.name}>
}
\references{
Steven C.H. Hoi, W. Liu, M.R. Lyu and W.Y. Ma (2003).
Distance metric learning, with application to clustering with side-information.
}
\keyword{GDM}
\keyword{distance}
\keyword{global}
\keyword{learning}
\keyword{mahalanobis}
\keyword{metirc}
\keyword{metric}
\keyword{transformation}

