% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build_covform}
\alias{build_covform}
\alias{build_covobj}
\title{Build a object or formula to use with covset.}
\usage{
build_covform(
  var,
  dist,
  args,
  lower = NULL,
  upper = NULL,
  by = NULL,
  envir = parent.frame()
)

build_covobj(
  var,
  dist,
  args,
  upper = NULL,
  lower = NULL,
  by = NULL,
  envir = parent.frame()
)
}
\arguments{
\item{var}{variable name, character}

\item{dist}{distribution function name}

\item{args}{character vector of arguments for \code{dist}}

\item{lower}{lower limits for var}

\item{upper}{upper limits for var}

\item{by}{grouping variable}

\item{envir}{environment for resolving symbols in expressions}
}
\description{
\code{build_covform} formulates then parses a formula that
can be used in a covset. \code{build_covobj} just assembles
the object directly.
}
\details{
When length of \code{var} is greater than one,
both \code{lower} and \code{upper} must be named vectors when specifiation is
made.  However, it is acceptable to specify nothing or to use unnamed limits
when the lenght of var is 1.
}
\examples{

build_covform("WT", "rnorm", c("mu = 80", "sd = 40"), lower = 40, upper = 140)
build_covform("WT", "rnorm", "80,40", lower = 40, upper = 140)

build_covobj("WT", "rnorm", "80,40", lower = 40, upper = 140)

}
