% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simEdgesSmooth.R
\name{engineEdge}
\alias{engineEdge}
\title{Implementation of simulation engine for dynamic networks using smoothing estimates of change statistics.}
\usage{
engineEdge(
  start_network,
  inputcoeff,
  ns,
  model.terms,
  model.formula,
  graph_mode,
  group,
  intercept,
  exvar,
  maxlag,
  lagmat,
  ylag,
  lambda = NA,
  method = "bayesglm",
  alpha.glmnet,
  paramout = TRUE
)
}
\arguments{
\item{start_network}{Initial list of networks}

\item{inputcoeff}{coefficient vector}

\item{ns}{number of time points for simulation}

\item{model.terms}{model terms in formula}

\item{model.formula}{model formula (ergm)}

\item{graph_mode}{'digraph' by default}

\item{group}{group terms}

\item{intercept}{intercept terms}

\item{exvar}{extraneous covariates}

\item{maxlag}{maximum lag}

\item{lagmat}{lag matrix}

\item{ylag}{lag vector for network lag terms}

\item{lambda}{NA}

\item{method}{'bayesglm' by default}

\item{alpha.glmnet}{NA}

\item{paramout}{T/F parameter estimation is returned.}
}
\value{
list:
  out_network: list of predicted networks
  coefmat: if paramout is TRUE, matrix of coefficients at all time.
}
\description{
Implementation of simulation engine for dynamic networks using smoothing estimates of change statistics.
}
\examples{
\dontrun{
input_network=rdNets[1:6];
model.terms=c("triadcensus.003", "triadcensus.012", "triadcensus.102", "triadcensus.021D", "gwesp");
model.formula = net~triadcensus(0:3)+gwesp(decay = 0, fixed=FALSE, cutoff=30)-1;
graph_mode='digraph';
group='dnc';
alpha.glmnet=1
directed=TRUE;
method <- 'bayesglm'
maxlag <- 3
lambda=NA
intercept = c("edges")
cdim <- length(model.terms)
lagmat <- matrix(sample(c(0,1),(maxlag+1)*cdim,replace = TRUE),ncol = cdim)
ylag <- rep(1,maxlag)
lagmat[1,] <- rep(0,ncol(lagmat))
out <- paramEdge(input_network,model.terms, model.formula,
                graph_mode="digraph",group,intercept = c("edges"),exvar=NA,
                maxlag = 3,
                lagmat = lagmat,
                ylag = rep(1,maxlag),
                lambda = NA, method='bayesglm',
                alpha.glmnet=1)
#
start_network <- input_network
inputcoeff <- out$coef$coef
nvertex <- 47
ns <- 10
exvar <- NA
tmp <- suppressWarnings(engineEdge(start_network=start_network,inputcoeff=inputcoeff,ns=ns,
                     model.terms=model.terms, model.formula=model.formula,
                     graph_mode=graph_mode,group=group,intercept=intercept,
                     exvar=exvar,
                     maxlag=maxlag,
                     lagmat=lagmat,
                     ylag=ylag,
                     lambda = NA, method='bayesglm',
                     alpha.glmnet=alpha.glmnet))}

}
\author{
Abhirup
}
