% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{testRaw-tag}
\alias{testRaw-tag}
\alias{@testRaw}
\title{Add a line of code to the test}
\description{
\verb{@testRaw} adds an arbitrary line of code to your test, without including it
in the .Rd example.
}
\details{
\verb{@testRaw} adds an arbitrary line of code to your test:

\if{html}{\out{<div class="sourceCode">}}\preformatted{#' @doctest
#' @testRaw skip_on_cran("Takes too long")
#' @expect equal(6765)
#' fibonacci(20)
}\if{html}{\out{</div>}}

Unless your doctest has at least one \link{@expect} or \link{@expectRaw} tag, no test
will be created. So use those tags, not \verb{@testRaw}, to add expectations.

Remember that the main purpose of examples is to document your package for
your users. If your code is getting too different from your example, consider
splitting it off into a proper test file. To do this, rename the
file in \code{tests/testthat}, and deleting the \verb{Generated by doctest} comment.
}
