% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deduplicate.R
\name{dodgr_deduplicate_graph}
\alias{dodgr_deduplicate_graph}
\title{Deduplicate edges in a graph}
\usage{
dodgr_deduplicate_graph(graph)
}
\arguments{
\item{graph}{Any 'dodgr' graph or network.}
}
\value{
A potentially modified version of graph, with any formerly duplicated
edges reduces to single rows containing minimal weighted distances and times.
}
\description{
Graph may have duplicated edges, particularly when extracted as
\link{dodgr_streetnet} objects. This function de-duplicates any repeated
edges, reducing weighted distances and times to the minimal values from all
duplicates.
}
\examples{
net0 <- weight_streetnet (hampi, wt_profile = "foot")
nrow (net0)
# Duplicate part of input data:
h2 <- rbind (hampi, hampi [1, ])
net1 <- weight_streetnet (h2, wt_profile = "foot")
nrow (net1) # network then has more edges
net2 <- dodgr_deduplicate_graph (net1)
nrow (net2)
stopifnot (identical (nrow (net0), nrow (net2)))
}
\seealso{
Other conversion: 
\code{\link{dodgr_to_igraph}()},
\code{\link{dodgr_to_sf}()},
\code{\link{dodgr_to_sfc}()},
\code{\link{dodgr_to_tidygraph}()},
\code{\link{igraph_to_dodgr}()}
}
\concept{conversion}
