% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-merge.R
\name{merge_directed_graph}
\alias{merge_directed_graph}
\title{Merge directed edges into equivalent undirected edges.}
\usage{
merge_directed_graph(graph, col_names = c("flow"))
}
\arguments{
\item{graph}{A undirected graph in which directed edges of the input graph
have been merged through aggregation to yield a single, undirected edge
between each pair of vertices.}

\item{col_names}{Names of columns to be merged through aggregation. Values
for these columns in resultant undirected graph will be aggregated from
directed values.}
}
\value{
An equivalent graph in which all directed edges have been reduced to
single, undirected edges, and all values of the specified column(s) have been
aggregated across directions to undirected values.
}
\description{
Merge directed edges into equivalent undirected values by aggregating across
directions. This function is primarily intended to aid visualisation of
directed graphs, particularly visualising the results of the
\link{dodgr_flows_aggregate} and \link{dodgr_flows_disperse} functions, which
return columns of aggregated flows directed along each edge of a graph.
}
\examples{
graph <- weight_streetnet (hampi)
from <- sample (graph$from_id, size = 10)
to <- sample (graph$to_id, size = 5)
to <- to [!to \%in\% from]
flows <- matrix (10 * runif (length (from) * length (to)),
    nrow = length (from)
)
graph <- dodgr_flows_aggregate (graph, from = from, to = to, flows = flows)
# graph then has an additonal 'flows` column of aggregate flows along all
# edges. These flows are directed, and can be aggregated to equivalent
# undirected flows on an equivalent undirected graph with:
graph_undir <- merge_directed_graph (graph)
# This graph will only include those edges having non-zero flows, and so:
nrow (graph)
nrow (graph_undir) # the latter is much smaller
}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{dodgr_vertices}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
