% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsd.R
\name{lsd}
\alias{lsd}
\title{Analysis of Latin Square Design}
\usage{
lsd(data, treatmentvector, row, column, MultipleComparisonTest)
}
\arguments{
\item{data}{dependent variables}

\item{treatmentvector}{vector containing treatments}

\item{row}{vector for rows}

\item{column}{vector for columns}

\item{MultipleComparisonTest}{0 for no test, 1 for LSD test, 2 for Duncan test and 3 for HSD test}
}
\value{
ANOVA, interpretation of ANOVA, R-square, normality test result, SEm, SEd and multiple comparison test result
}
\description{
The function gives ANOVA, R-square of the model, normality testing of residuals, SEm (standard error of mean), SEd (standard error of difference), interpretation of ANOVA results and multiple comparison test for means.
}
\examples{
data(lsddata)
#LSD analysis with LSD test for Yield only
lsd(lsddata[4],lsddata$Treatment,lsddata$Row,lsddata$Column,1)
#LSD analysis with LSD test for Yield and Plant Height
lsd(lsddata[4:5],lsddata$Treatment,lsddata$Row,lsddata$Column,1)
}
