% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/donut_geoms.R
\docType{data}
\name{donut_geom}
\alias{donut_geom}
\alias{StatDonutInt}
\alias{geom_donut_int0}
\alias{StatDonutIntHl}
\alias{geom_donut_int_hl}
\alias{geom_donut_int}
\alias{StatDonutExt}
\alias{geom_donut_ext0}
\alias{StatDonutExtHl}
\alias{geom_donut_ext_hl}
\alias{geom_donut_ext}
\title{Create pie or donut chart}
\format{
An object of class \code{StatDonutInt} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.

An object of class \code{StatDonutIntHl} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.

An object of class \code{StatDonutExt} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.

An object of class \code{StatDonutExtHl} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 4.
}
\usage{
geom_donut_int0(
  mapping = NULL,
  data = NULL,
  stat = "donut_int",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  r_int = 0,
  r_ext = 1,
  hl_shift = 0.1,
  ...
)

geom_donut_int(..., hl_col = "firebrick")

geom_donut_ext0(
  mapping = NULL,
  data = NULL,
  stat = "donut_ext",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  r_int = 1.5,
  r_ext = 2,
  hl_shift = 0.1,
  ...
)

geom_donut_ext(..., hl_col = "firebrick")
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{r_int}{Internal donut radius}

\item{r_ext}{External pie or donut radius}

\item{hl_shift}{Sets the spacing to show highlighted segments}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{hl_col}{Sets the color for highlighted segments. It's possible to use both simultaneously \code{hl_col} and generic \code{colour}}
}
\value{
None
}
\description{
Create pie or donut charts while retaining ggplot flexibility, such as leveraging faceting and palettes, and fine-tuning appearance
\itemize{
\item The function \code{geom_donut_int()} creates visually \strong{internal} donut layer as aggregation of passed values
\item The function \code{geom_donut_ext()} creates visually \strong{external} donut layer of passed values
\item \code{geom_donut_int0()} and \code{geom_donut_ext()} are generic geoms not supporting highlight feature
}
}
\details{
There are two additional aesthetics possible to use:
\itemize{
\item \code{highlight} - optional aesthetic which expects logical (TRUE/FALSE) variable in order to highlight particular donut segments
\item \code{opacity} - operates pretty much the same as \code{alpha} but ensure more contrast colors and removes legend. Once \code{alpha} is set \code{opacity} does not affect a chart
}
}
\examples{
# Create an example
set.seed(1605)
n <- 20
df <- dplyr::tibble(
  lvl1 = sample(LETTERS[1:5], n, TRUE),
  lvl2 = sample(LETTERS[6:24], n, TRUE),
  value = sample(1:20, n, TRUE),
  highlight_ext = sample(c(FALSE,TRUE), n, TRUE, c(.7, .3))) |>
  dplyr::mutate(highlight_int = ifelse(lvl1 == "A", TRUE, FALSE))

# Create a simple pie chart
ggplot(df, aes(value = value, fill=lvl1)) +
  geom_donut_int(alpha=.6) +
  coord_polar(theta = "y")

# Create a simple donut chart that can handle more granular data
# and highlight specific segments
ggplot(df, aes(value = value, fill=lvl2, highlight=highlight_ext)) +
  geom_donut_int(r_int=.5, alpha=.6, linewidth=.2) +
  coord_polar(theta = "y") +
  xlim(0, 1.5)

# Perform data preparation tasks with `packing()`
# and apply specific color
packing(df, value) |>
  ggplot(aes(value = value, fill=lvl2, highlight=highlight_ext)) +
  geom_donut_int(r_int=.5, alpha=.6, linewidth=.2, col = "gray20") +
  coord_polar(theta = "y") +
  xlim(0, 1.5)

# Built combined donut chart with interanl and external layers
dplyr::bind_rows(
# arrange by value
`arrange()` = dplyr::arrange(df, lvl1, lvl2, value),
# pack values for better space management
`packing()` = packing(df, value, lvl1),
.id = "prep_type") |>
 ggplot(aes(value = value, fill=lvl1)) +
 geom_donut_int(aes(highlight=highlight_int), alpha=.6) +
 geom_donut_ext(aes(opacity=lvl2, highlight=highlight_int)) +
 # apply facets
 facet_grid(~prep_type) +
 # style chart with palette and theme
 scale_fill_viridis_d(option = "inferno", begin = .1, end = .7) +
 theme_void() +
 coord_polar(theta = "y") +
 xlim(0, 2.5)

}
\keyword{datasets}
