% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topography.R
\name{oedist}
\alias{oedist}
\title{Distance from outer enamel surface to enamel dentine junction}
\usage{
oedist(oes, edj, ray = FALSE)
}
\arguments{
\item{oes}{object of class mesh3d; should be the outer enamel surface}

\item{edj}{object of class mesh3d; should be the enamel-dentine junction}

\item{ray}{logical, if TRUE the search is along vertex normals (default is FALSE)}
}
\value{
A numeric vector of vertex-to-mesh distance values for all the polygons of the x mesh.
}
\description{
Compute the distance from enamel vertices to dentine mesh.
}
\examples{
edd <- oedist(dkmodel$cusp, dkmodel$flat)
summary(edd)
AETgeom <- mean(edd)
#Geometric relative enamel thickness, obtained by dividing AETgeom by the
#square root of EDJ area
#Note: it is different from classic RET which requires the volume of the
#dentine inside the enamel cap (see Thiery et al., 2017)
AETgeom/sqrt(Rvcg::vcgArea(dkmodel$flat))
#Absolute crown strength:
edj_radius <- max(dist(cbind(dkmodel$flat$vb[1,], dkmodel$flat$vb[2,])))/2
sqrt(mean(edd) * edj_radius)

#render on a map:
oedist <- doolkit::oedist(dkmodel$cusp, dkmodel$flat)
dkmap(dkmodel$cusp, oedist)
#distance map can also be rendered on EDJ surface:
eodist <- oedist(dkmodel$flat, dkmodel$cusp)
dkmap(dkmodel$flat, eodist)
}
\references{
\doi{10.1371/journal.pone.0066142}{Guy et al. (2013)}

\doi{10.1371/journal.pone.0138802}{Guy et al. (2015)}

\doi{10.3389/fphys.2017.00524}{Thiery et al. (2017)}

\doi{10.1098/rsbl.2019.0671}{Schwartz et al. (2020)}
}
\seealso{
\code{\link[Morpho]{meshDist}}
}
