% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{plot.doremiparam}
\alias{plot.doremiparam}
\title{S3 method to plot DOREMIPARAM objects}
\usage{
\method{plot}{doremiparam}(x, ...)
}
\arguments{
\item{x}{DOREMIPARAM object resulting from the aforementioned function}

\item{...}{includes the additional arguments inherited from the generic plot method}
}
\value{
Returns a plot showing the evolution of the first/second order differential equation coefficients and R2 with the values taken by the embedding number/smoothing parameter
(see details of \code{\link{optimum_param}} function).
The function uses \code{\link[ggplot2]{ggplot}}
to generate the graphs and thus it is possible to override the values of axis labels, legend and title through ggplot commands.
}
\description{
\code{plot.doremiparam} generates a plot of the parameters resulting from the \code{\link{optimum_param}} function
}
\examples{
mydata <- generate.panel.1order(time = 0:130,
                          excitation = c(rep(0,30),rep(1,50),rep(0,51)),
                          nind = 5,
                          internoise = 0.2,
                          intranoise = 100)
myres<- optimum_param (data = mydata,
                         id = "id",
                         input ="excitation",
                         time = "time",
                         signal = "signal",
                         model = "1order",
                         dermethod = "gold",
                         pmin = 3,
                         pmax = 11,
                         pstep = 2)
plot(myres)
}
