% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.dosresmeta}
\alias{logLik.dosresmeta}
\title{Extract Log-Likelihood from dosresmeta Objects}
\usage{
\method{logLik}{dosresmeta}(object, ...)
}
\arguments{
\item{object}{an object of class "\code{dosresmeta}"}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
A numeric scalar of class \code{"logLik"}.
}
\description{
This method function returns the log-likelihood for fitted dose-response models represented in objects of class "\code{dosresmeta}".
}
\examples{
data("alcohol_crc")

## Dose-response model assuming linearity
lin <- dosresmeta(formula = logrr ~ dose, type = type, id = id, se = se, 
           cases = cases, n = peryears, data = alcohol_crc, proc = "1stage")

## Log-likelihood
ll <- logLik(lin)
ll
attributes(ll)

## AIC and BIC
AIC(ll)
BIC(ll)

}
\seealso{
\code{\link{dosresmeta}}, \code{\link{dosresmeta-package}}, \code{\link{logLik}}
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
