% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdp.R
\name{cdp}
\alias{cdp}
\title{L1 convex clustering with a single lambda.}
\usage{
cdp(X, lam)
}
\arguments{
\item{X}{a data matrix of n * p or a data vector with length n.}

\item{lam}{a tuning parameter.}
}
\value{
the estimated centroids.
}
\description{
L1 convex clustering with a single lambda.
}
\details{
A list with length p equal to the dimension of the data matrix. Each dimension includes a vector of the estimated centroids.
}
\examples{
# generate a data matrix with n = 10 and p = 2.
X = matrix(rnorm(10*2), 10, 2)
lam = find_lambda(X)/2
# set a tuning parameter lambda.
cdp(X, lam)

}
