% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpaint.R
\name{cpaint}
\alias{cpaint}
\title{L1 convex clustering with a lambda sequence.}
\usage{
cpaint(X, lam)
}
\arguments{
\item{X}{a data matrix of n * p or a data vector with length n.}

\item{lam}{a sequence of lambdas.}
}
\value{
A sequence of estimated centroids.
}
\description{
L1 convex clustering with a lambda sequence.
}
\details{
A list with length p equal to the dimension of the data matrix. Each dimension includes a sequence of vectors. Each vector includes the estimated centroids with a certain tuning parameter lambda.
}
\examples{
# generate a data matrix with n = 10 and p = 2.
X = matrix(rnorm(10*2), 10, 2)
# set the biggest lambda in the sequence.
lam_max = find_lambda(X)
# set the length of the sequence.
K = 10
# equally separate the sequence with K.
Lam = sapply(1:K, function(i) i/K*lam_max)
cpaint(X,Lam)
}
