% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyrAssist.R
\name{dplyrAssist}
\alias{dplyrAssist}
\title{A shiny app for learn dplyr}
\usage{
dplyrAssist(df = NULL, right = NULL)
}
\arguments{
\item{df}{A tibble or a tbl_df or a data.frame to manipulate}

\item{right}{Optional second data(A tibble or a tbl_df or a data.frame) to join}
}
\value{
A manipulated tibble or NULL
}
\description{
Interactively manipulate a \code{data.frame} or a \code{tibble}. The resulting
code will be emitted as an R code.
}
\details{
This addin can be used to interactively manipulate a \code{data.frame} or a \code{tibble} using dplyr.
The intended way to use this is as follows:

1. Highlight a symbol naming a \code{data.frame} or a \code{tibble} in your R session,
   e.g. \code{mtcars},
2. Execute this addin, to interactively manipulate it.

When you're done, the code for data manipulation will be emitted
at the cursor position.
}
\examples{
library(tidyverse)
library(nycflights13)

\dontrun{
dplyrAssist(band_members,band_instruments)
dplyrAssist(flights)
result<-dplyrAssist(iris)
cat(attr(result,"code"))
}
}
