% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATEDGP.R
\name{ATEDGP}
\alias{ATEDGP}
\title{Simulates the data for ATE estimators}
\usage{
ATEDGP(dgptype, rndflag, n, g, pi)
}
\arguments{
\item{dgptype}{A scalar. 1, 2, 3 (Almost the same as 1-3 in the paper except that it does not have the DGP for D(1) or D(0)).}

\item{rndflag}{A scalar. method of covariate-adaptive randomization. 1-SRS; 2-WEI; 3-BCD; 4-SBR.}

\item{n}{Sample size.}

\item{g}{Number of strata. The authors set g = 4 in the Jiang et al. (2022).}

\item{pi}{A g x 1 vector. Targeted assignment probabilities across strata.}
}
\value{
ATEDGP returns a list containing 7 nx1 vectors named Y, X, S, A, Y1, Y0 and D.
   These seven vectors are the same as defined in Jiang et al. (2022).
   Note that vector X does not contain the constant term.
}
\description{
ATEDGP is the version of FuncDGP under full compliance.
}
\examples{
ATEDGP(dgptype = 1, rndflag = 1, n = 200, g = 4, pi = c(0.5, 0.5, 0.5, 0.5))
}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
