% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ATEJLTZ.R
\name{ATEJLTZ}
\alias{ATEJLTZ}
\title{ATEJLTZ runs the code for ATE estimator}
\usage{
ATEJLTZ(iMonte, dgptype, n, g, pi, iPert, iq = 0.05, iridge = 0.001, seed = 1)
}
\arguments{
\item{iMonte}{A scalar. Monte Carlo sizes.}

\item{dgptype}{A scalar. The value can be string 1, 2, or 3,
respectively corresponding to the three DGP schemes in the paper (See Jiang et al. (2022) for DGP details).}

\item{n}{Sample size.}

\item{g}{Number of strata. The authors set g=4 in Jiang et al. (2022).}

\item{pi}{Targeted assignment probability across strata.}

\item{iPert}{A scalar. iPert = 0 means size. Otherwise means power: iPert is the perturbation of false null.}

\item{iq}{A scalar. Size of hypothesis testing. The authors set iq = 0.05 in Jiang et al. (2022).}

\item{iridge}{A scalar. The penalization parameter in ridge regression.}

\item{seed}{A scalar. The random seed, the authors set seed = 1 in Jiang et al. (2022).}
}
\value{
A table summarizing the estimated results, mProd.
}
\description{
ATEJLTZ is the version of JLTZ under full compliance.
}
\examples{
\donttest{
# size, iPert = 0
ATEJLTZ(iMonte = 10, dgptype = 1, n = 200, g = 4,
    pi = c(0.5, 0.5, 0.5, 0.5), iPert = 0, iq = 0.05, iridge = 0.001)

# power, iPert = 1
ATEJLTZ(iMonte = 10, dgptype = 1, n = 200, g = 4,
    pi = c(0.5, 0.5, 0.5, 0.5), iPert = 1, iq = 0.05, iridge = 0.001)
    }
}
\references{
Jiang L, Linton O B, Tang H, Zhang Y. Improving estimation efficiency via regression-adjustment in covariate-adaptive randomizations with imperfect compliance [J]. 2022.
}
