% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_curve.R
\name{plot_do_curve}
\alias{plot_do_curve}
\title{Plot Dropout Curves}
\usage{
plot_do_curve(
  do_stats,
  linetypes = TRUE,
  stroke_width = 1,
  full_scale = TRUE,
  show_points = FALSE,
  show_confbands = FALSE,
  color_palette = "color_blind"
)
}
\arguments{
\item{do_stats}{data.frame containing dropout statistics table computed by \code{\link[=compute_stats]{compute_stats()}}.
Make sure your do_stats table contains a q_idx column indexing all question-items sequentially.}

\item{linetypes}{boolean Should different line types be used? Defaults to TRUE.}

\item{stroke_width}{numeric stroke width, defaults to 1.}

\item{full_scale}{boolean Should y axis range from 0 to 100? Defaults to TRUE,
FALSE cuts off at min percent remaining (>0).}

\item{show_points}{boolean Should dropout curves show individual data points? Defaults to FALSE.}

\item{show_confbands}{boolean Should there be confidence bands added to the plot? Defaults to FALSE.}

\item{color_palette}{character indicating which color palette to use. Defaults to 'color_blind',
alternatively choose 'gray' or 'default' for the ggplot2 default colors.}
}
\value{
Returns a \code{ggplot} object containing the dropout curve plot. Using the Shiny App version of
dropR, this plot can easily be downloaded in different formats.
}
\description{
This functions uses \code{ggplot2}to create drop out curves.
Please note that you should use \code{\link[=add_dropout_idx]{add_dropout_idx()}} and \code{\link[=compute_stats]{compute_stats()}} on your
data before running this function as it needs a certain data structure and variables to
work properly.
}
\examples{
do_stats <- compute_stats(add_dropout_idx(dropRdemo, 3:54),
by_cond = "experimental_condition",
no_of_vars = 52)

plot_do_curve(do_stats)

}
\seealso{
\code{\link[=add_dropout_idx]{add_dropout_idx()}} and \code{\link[=compute_stats]{compute_stats()}} which are necessary for the proper data structure.
}
