% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qhat_estimation_functions.R
\name{qhat_gam}
\alias{qhat_gam}
\title{Estimate marginal and joint distribution of lists j and k using generalized additive models.}
\usage{
qhat_gam(List.train, List.test, K = 2, j = 1, k = 2, margin = 0.005, ...)
}
\arguments{
\item{List.train}{The training data matrix used to estimate the distibution functions.}

\item{List.test}{The data matrix on which the estimator function is applied.}

\item{K}{The number of lists in the data.}

\item{j}{The first list that is conditionally independent.}

\item{k}{The second list that is conditionally independent.}

\item{margin}{The minimum value the estimates can attain to bound them away from zero.}

\item{...}{Any extra arguments passed into the function.}
}
\value{
A list of the marginal and joint distribution probabilities \code{q1}, \code{q2} and \code{q12}.
}
\description{
Estimate marginal and joint distribution of lists j and k using generalized additive models.
}
\examples{
\dontrun{
qhat = qhat_gam(List.train = List.train, List.test = List.test, margin = 0.005)
q1 = qhat$q1
q2 = qhat$q2
q12 = qhat$q12
}
}
\references{
Trevor Hastie (2020). gam: Generalized Additive Models. \emph{R package version 1.20}. https://CRAN.R-project.org/package=gam
}
