% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_ndd}
\alias{impute_ndd}
\title{Replace implausible or missing numerical daily doses (NDD)}
\usage{
impute_ndd(data, method, where = is.na, group = "population", ...)
}
\arguments{
\item{data}{A data frame containing columns \code{prodcode}, \code{pracid}, \code{patid}}

\item{method}{Method for imputing the values. See details.}

\item{where}{Logical vector, or function applied to \code{variable} returning such a vector, indicating which elements to impute. Defaults to \code{\link[base:NA]{is.na}}}

\item{group}{Level of structure for imputation. Defaults to whole study population.}

\item{...}{Extra arguments, currently ignored}
}
\value{
A data frame of the same structure as \code{data}, with values imputed
}
\description{
Replace implausible or missing numerical daily doses (NDD)
}
\examples{
impute_ndd(example_therapy, 'mean')

}
