% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_matrices.R
\name{make_matrices}
\alias{make_matrices}
\title{Make path matrices}
\usage{
make_matrices(beta_p, model, times, variables)
}
\arguments{
\item{beta_p}{vector parameters.}

\item{model}{matrix or data.frame with the following columns, and one row
per one-headed or two-headed arrow in the dynamic structural model:
\describe{
\item{direction}{whether a path coefficient is one-headed (1) or two-headed (2)}
\item{lag}{whether the lag associated with a given coefficient}
\item{start}{starting value, used when \code{parameter=0}}
\item{parameter}{The parameter number from \code{beta_p} associated with a given path}
\item{first}{The variable at the tail of a given path}
\item{second}{The variable at the head of a given path}
}}

\item{times}{integer-vector of times to use when defining matrices}

\item{variables}{character-vector listing variables}
}
\value{
A named list of matrices including:
\describe{
\item{P_kk}{The matrix of interactions, i.e., one-headed arrows}
\item{G_kk}{The matrix of exogenous covariance, i.e., two-headed arrows}
}
}
\description{
Constructs path matrices for dynamic structural equation model (DSEM)
using a vector of parameters and specification of the DSEM
}
\details{
When \code{length(times)} is \eqn{T} and \code{length(variables)} is \eqn{J},
\code{make_matrices} returns matrices of dimension \eqn{TJ \times TJ} representing
paths among \eqn{vec(\mathbf{X})} where matrix \eqn{\mathbf{X}} has dimension
\eqn{T \times J} and \eqn{vec} stacks columns into a single long vector
}
