% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsos-s3.R
\name{print.outlier.test}
\alias{print.outlier.test}
\title{Print frequentist test for no adverse shift.}
\usage{
\method{print}{outlier.test}(x, ...)
}
\arguments{
\item{x}{A \code{outlier.test} object from a D-SOS test.}

\item{...}{Placeholder to be compatible with S3 method \code{plot}.}
}
\value{
Print to screen: display p-value and other information.
}
\description{
Print frequentist test for no adverse shift.
}
\examples{
\donttest{
set.seed(12345)
os_train <- rnorm(n = 3e2)
os_test <- rnorm(n = 3e2)
test_to_print <- at_from_os(os_train, os_test)
# Also: pt_from_os(os_train, os_test) for permutation test
test_to_print
}

}
\seealso{
Other s3-method: 
\code{\link{plot.outlier.bayes}()},
\code{\link{plot.outlier.test}()},
\code{\link{print.outlier.bayes}()}
}
\concept{s3-method}
