% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/component_samplers.R
\name{sampleAR1}
\alias{sampleAR1}
\title{Sample the AR(1) coefficient(s)}
\usage{
sampleAR1(h_yc, h_phi, h_sigma_eta_t, prior_dhs_phi = NULL)
}
\arguments{
\item{h_yc}{the \code{T x p} matrix of centered log-volatilities
(i.e., the log-vols minus the unconditional means \code{dhs_mean})}

\item{h_phi}{the \code{p x 1} vector of previous AR(1) coefficient(s)}

\item{h_sigma_eta_t}{the \code{T x p} matrix of log-vol innovation standard deviations}

\item{prior_dhs_phi}{the parameters of the prior for the log-volatility AR(1) coefficient \code{dhs_phi};
either \code{NULL} for uniform on [ -1,1 ] or a 2-dimensional vector of (shape1, shape2) for a Beta prior
on \code{[(dhs_phi + 1)/2]}}
}
\value{
\code{p x 1} vector of sampled AR(1) coefficient(s)
}
\description{
Compute one draw of the AR(1) coefficient in a model with Gaussian innovations
and time-dependent innovation variances. In particular, we use the sampler for the
log-volatility AR(1) process with the parameter-expanded Polya-Gamma sampler. The sampler also applies
to a multivariate case with independent components.
}
\note{
For the standard AR(1) case, \code{p = 1}. However, the function applies more
generally for sampling \code{p > 1} independent AR(1) processes (jointly).
}
