% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pDTGIW.R
\name{pDTGIW}
\alias{pDTGIW}
\title{The cumulative distribution function (CDF) for Discrete Transmuted Generalized Inverse Weibull (DTGIW) distribution.}
\usage{
pDTGIW(q, alpha, beta, lambda, theta, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{alpha}{shape parameter#1.}

\item{beta}{scale parameter.}

\item{lambda}{shape pameter#2.}

\item{theta}{the transmuted parameter.}

\item{lower.tail}{logical; if TRUE (default), probabilities are Prob of X less than or equal to x. Otherwise, Prob of X greater than x.}

\item{log.p}{logical(TRUE or FALSE); if log.p=FALSE, then return the CDF; if log.p=TRUE, then return the natural logarithms of the CDF.}
}
\value{
the cdf of DTGIW distribution
}
\description{
This function calculated the CDF of the DTGIW distribution.
}
\details{
The PMF of DTGIW distribution is shown in Theorem 1. based on the research paper in references.
For discrete random variables, the CDF of DTGIW distribution can be calculated by summation of the PMF.
}
\examples{
x <- c(0:10)
pDTGIW(x,3.45,0.7,1.05,0)

}
\references{
Atchanut Rattanalertnusorn and Sirinapa Aryuyuen (2021).
The zero-truncated discrete transmuted generalized inverse Weibull distribution and its applications,
Songklanakarin Journal of Science and Technology (SJST), Volume 43 No.4 (July - August 2021), pp. 1140 - 1151. DOI: 10.14456/sjst-psu.2021.149
}
