% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round.R
\name{round_sum}
\alias{round_sum}
\title{Rounds numbers while preserving the total sum}
\usage{
round_sum(x, digits = 0L)
}
\arguments{
\item{x}{A numeric vector of non-negative values that you want to round.
Missing values (\code{NA}) are ignored.}

\item{digits}{The number of decimal places to round to. Default is \code{0}
(integer rounding).}
}
\value{
A numeric vector of the same length as \code{x}, with values rounded in
such a way that the total sum is preserved.
}
\description{
\code{\link[=round_sum]{round_sum()}} rounds a numeric vector of non-negative values to a specified
number of decimal places while ensuring that the sum of the rounded value
remains as close as possible to the original total.
}
\examples{
# Rounds to integers, preserving the sum of 100.
x <- c(33.3333, 33.3333, 33.3334)
(y <- round_sum(x))
identical(sum(x), sum(y))

# Rounds to integers, preserving the sum of 1002.
x <- c(100.5, 200.25, 300.75, 400.5)
(y <- round_sum(x))
identical(sum(x), sum(y))

# Rounds to one decimal place, preserving the total sum.
x <- c(12.345, 67.890, 19.765)
(y <- round_sum(x))
identical(sum(x), sum(y))

}
