% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopping_delegates.R
\name{stop_for_consensus_reached}
\alias{stop_for_consensus_reached}
\title{Stopping for consensus}
\usage{
stop_for_consensus_reached(x, req_at_mtd)
}
\arguments{
\item{x}{An object of class 'mtd'.}

\item{req_at_mtd}{An integer; the number of patients required at current
estimate of MTD to suggest stopping for consensus.}
}
\description{
This is a function for use with applied_crm for the stop_func
    argument. The rule will suggest stopping in the scenario that a
    particular number of patients has already been treated at the current
    recommended MTD.
}
\details{
This function is an example of a possible stopping function to be
    used with applied_crm, it will modifiy the 'mtd' class object produced by
    applied_crm to include a logical value under the name 'stop' indicting
    whether or not the trial should stop. The package dtpcrm contains a few
    of these functions for possible use with applied_crm.
}
\examples{
prior  <- c(0.1, 0.3, 0.5)
target <- 0.2
tox    <- c(0, 0, 1, 0, 1, 1)
level  <- c(1, 1, 1, 2, 2, 2)

stop_rule <- function(x){
  x <- stop_for_consensus_reached(x, req_at_mtd = 6)
}

crm <- applied_crm(prior, target, tox, level, no_skip_esc = TRUE, no_skip_deesc = TRUE,
                   global_coherent_esc = TRUE, stop_func = stop_rule)

}
\keyword{CRM}
\keyword{dtpcrm}
\keyword{stop}
