% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{p_get_as_dot}
\alias{p_get_as_dot}
\title{DOT output}
\usage{
p_get_as_dot(
  .data,
  fill = .defaultFill(),
  fontsize = .defaultFontSize(),
  colour = .defaultColour(),
  rankdir = .defaultDirection(),
  rounded = .defaultRounded(),
  fontname = .defaultFontName(),
  bgcolour = .defaultBgColour(),
  ...
)
}
\arguments{
\item{.data}{the tracked dataframe}

\item{fill}{the default node fill colour, any R colour or hex value}

\item{fontsize}{the default font size in points}

\item{colour}{the default font colour, any R colour or hex value}

\item{rankdir}{the dot rank direction (one of \code{TB},\code{LR},\code{BT},\code{RL})}

\item{rounded}{should the node corners be rounded?}

\item{fontname}{the font to use. Must exist on the system.}

\item{bgcolour}{the background, may be "transparent", any R colour or hex value}

\item{...}{not used}
}
\value{
a representation of the history graph in \code{Graphviz} dot format.
}
\description{
(advance usage) outputs a \code{dtrackr} history graph as a DOT string for rendering with \code{Graphviz}
}
\examples{
library(dplyr)
library(dtrackr)

tmp = iris \%>\% track() \%>\% comment(.tag = "step1") \%>\% filter(Species!="versicolor")
dot = tmp \%>\% dplyr::group_by(Species) \%>\% comment(.tag="step2") \%>\% p_get_as_dot()
cat(dot)
}
