% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/op_create_csv.R
\name{op_create_csv}
\alias{op_create_csv}
\title{Create CSV from JSON files}
\usage{
op_create_csv(
  input_path,
  output_path = input_path,
  model = "all",
  include_filename = FALSE,
  include_labels = FALSE,
  frame_width = 1920,
  export_type = "dyad"
)
}
\arguments{
\item{input_path}{Path to the directory containing JSON files.}

\item{output_path}{Path to the directory where CSV files will be saved. Defaults to the input path.}

\item{model}{The model to use: "all", "body", "hands", or "face". Defaults to "all".}

\item{include_filename}{Boolean indicating whether to include the base filename in column names. Defaults to FALSE.}

\item{include_labels}{Boolean indicating whether to rename columns based on region labels. Defaults to FALSE.}

\item{frame_width}{Width of the frame. Defaults to 1920.}

\item{export_type}{Type of export: "individual" to export separate CSV files for each person,
"dyad" to export both persons' data into a single CSV file. Defaults to "individual".}
}
\value{
No return value. This function is called for its side effects, which include writing
CSV files to the specified output directory.
}
\description{
This function reads JSON files from the specified directory, processes the pose keypoints,
and saves the results into CSV files.
}
\examples{
\donttest{
# Path to example JSON files included with the package
input_path <- system.file("extdata/json_files", package = "duet")

# Temporary output directory
output_path <- tempfile("output_csv")
dir.create(output_path)

# Run the function using the provided data
op_create_csv(
  input_path = input_path,
  output_path = output_path,
  model = "body",
  include_filename = TRUE,
  include_labels = TRUE,
  frame_width = 1920,
  export_type = "dyad"
)
}
}
