% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_decreasing.R
\name{cut_decreasing}
\alias{cut_decreasing}
\title{Cut with Decreasing Factor Levels}
\usage{
cut_decreasing(x, breaks, include.lowest = FALSE, right = TRUE, ...)
}
\arguments{
\item{x, breaks, include.lowest, right}{See \code{\link{cut}}.
specifying number of intervals is not currently supported).}

\item{...}{Arguments to pass to \code{\link{cut}}.}
}
\value{
Factor variable.
}
\description{
Convenience function to get decreasing factor levels from \code{\link{cut}}. 
Currently requires specifying \code{breaks} as vector of cutpoints rather 
than number of desired intervals.
}
\examples{
# In mtcars dataset, create 3 mpg groups
table(cut(mtcars$mpg, breaks = c(-Inf, 15, 20, Inf)))

# Repeat with cut_decreasing to get factor levels ordered from high to low. 
# To match cut here, need to specify right = FALSE
table(cut_decreasing(mtcars$mpg, breaks = c(Inf, 20, 15, -Inf), right = FALSE))

# You can specify breaks from low to high, but then include.lowest and right 
# arguments get confusing
table(cut_decreasing(mtcars$mpg, breaks = c(-Inf, 15, 20, Inf), right = TRUE))

}
