% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_experiment.R
\name{generate_experiment}
\alias{generate_experiment}
\alias{list_experiment_samplers}
\alias{experiment_snapshot}
\alias{experiment_synchronised}
\title{Sample cells from the simulations}
\usage{
generate_experiment(model)

list_experiment_samplers()

experiment_snapshot(
  realcount = NULL,
  map_reference_cpm = TRUE,
  map_reference_ls = TRUE,
  weight_bw = 0.1
)

experiment_synchronised(
  realcount = NULL,
  map_reference_cpm = TRUE,
  map_reference_ls = TRUE,
  num_timepoints = 8,
  pct_between = 0.75
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the simulations have been run with \code{\link[=generate_cells]{generate_cells()}}.}

\item{realcount}{The name of a dataset in \link{realcounts}. If \code{NULL}, a random
dataset will be sampled from \link{realcounts}.}

\item{map_reference_cpm}{Whether or not to try to match the CPM distribution to that of a reference dataset.}

\item{map_reference_ls}{Whether or not to try to match the distribution of the library sizes to that of the reference dataset.}

\item{weight_bw}{[snapshot] A bandwidth parameter for determining the distribution of
cells along each edge in order to perform weighted sampling.}

\item{num_timepoints}{[synchronised] The number of time points used in the experiment.}

\item{pct_between}{[synchronised] The percentage of 'unused' simulation time.}
}
\value{
A dyngen model.
}
\description{
\code{\link[=generate_experiment]{generate_experiment()}} samples cells along the different simulations.
Two approaches are implemented: sampling from an unsynchronised population of single cells (snapshot) or
sampling at multiple time points in a synchronised population (time series).
}
\details{
\code{\link[=experiment_snapshot]{experiment_snapshot()}} samples the cells using the length of each edge in the milestone network as weights.
See Supplementary Figure 7A from the dyngen paper for an illustration of how these weights are computed.

\code{\link[=experiment_synchronised]{experiment_synchronised()}} samples the cells along the simulation timeline by binning it into \code{num_timepoints}
groups separated by \code{num_timepoints-1} gaps.
See Supplementary Figure 7B from the dyngen paper for an illustration of how the timepoint groups are computed.
}
\examples{
names(list_experiment_samplers())

model <- 
  initialise_model(
    backbone = backbone_bifurcating(),
    experiment = experiment_synchronised()
  )

\donttest{
data("example_model")
model <- example_model \%>\% generate_experiment() 

plot_experiment_dimred(model)
}
}
