% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_gold_expression}
\alias{plot_gold_expression}
\title{Visualise the expression of the gold standard over simulation time}
\usage{
plot_gold_expression(
  model,
  what = c("mol_premrna", "mol_mrna", "mol_protein"),
  label_changing = TRUE
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the simulations have been run with \code{\link[=generate_gold_standard]{generate_gold_standard()}}.}

\item{what}{Which molecule types to visualise.}

\item{label_changing}{Whether or not to add a label next to changing molecules.}
}
\value{
A ggplot2 object.
}
\description{
Visualise the expression of the gold standard over simulation time
}
\examples{
data("example_model")
plot_gold_expression(example_model, what = "mol_mrna", label_changing = FALSE)
}
