% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ea_curve_fitting4.R
\name{eadrm}
\alias{eadrm}
\title{Fits a dose-response curve using an evolutionary algorithm}
\usage{
eadrm(
  obs,
  xvals,
  model = "h4",
  pop.size = 1000,
  stable.pop.size = 200,
  num.tournaments = 20,
  tournament.size = 10,
  max.generations = 500,
  stop.generations = 50,
  epsilon = 0.1
)
}
\arguments{
\item{obs}{A vector of response values (y-values).}

\item{xvals}{A vector of doses (x-values).}

\item{model}{Type of dose-response model to fit. Possible values
include "h3", "h4", and "h5" (corresponding to 3-parameter,
4-parameter, and 5-parameter log-logistic models, respectively),
"e" (corresponding to an exponential model) and "all" (which allows
the procedure to evaluate all four types of models). Defaults to "h4".}

\item{pop.size}{The number of initial potential solutions.
Defaults to 1000.}

\item{stable.pop.size}{This quantity is divided by the number of
tournaments to calculate the number of children in each generation.
Defaults to 200.}

\item{num.tournaments}{The number of tournaments in each generation.
Defaults to 20.}

\item{tournament.size}{The number of players (i.e., models to
consider) in each tournament. Defaults to 10.}

\item{max.generations}{The maximum number of generations. If this
number is reached, the algorithm immediately terminates. Defaults to
500.}

\item{stop.generations}{The algorithm will also terminate if there is
no improvement in fitness in stop.generation generations. Defaults to
50.}

\item{epsilon}{If three successive new models produce an improvement
of less than epsilon in fitness, the procedure will terminate.
Defaults to 0.1.}
}
\value{
An object of class eadrm, which is a list containing the
following elements:
\describe{
\item{Model:}{Specifies the type of model (i.e., "h3", "h4", "h5", or
"e")}
\item{R2:}{Fitness for the final model}
\item{params:}{A vector of coefficients for the final model}
\item{xvals:}{The original x values (concentrations) for the model}
\item{yvals:}{The original y values (responses) for the model}
}
}
\description{
Uses an evolutionary algorithm to fit a set of four possible
dose-response models. The evolutionary parameters and stopping
rules can be customized by the user.
}
\section{Details}{

The procedure will initially generate pop.size possible solutions.
The fitness for each solution will be calculated. In each generation,
a series of tournaments are performed. The children of the surviving
models from the previous generation are mutated. The model with the
best fitness "wins" each tournament and survives to the next
generation. The procedure continues until the maximum number of
generations is reached or the fitness fails to improve substantially
over a sufficient number of generations.
}

\examples{
ea.fit <- eadrm(CarboA$y, CarboA$x)
}
\references{
Ma, J., Bair, E., Motsinger-Reif, A. "Nonlinear Dose-response Modeling
of High-Throughput Screening Data Using an Evolutionary Algorithm",
Dose Response 18(2):1559325820926734 (2020).
}
