% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external.R
\name{createRis}
\alias{createRis}
\title{Create RIS format citation for software}
\usage{
createRis(
  title,
  authors,
  year,
  url = NULL,
  version = NULL,
  doi = NULL,
  notes = NULL,
  publisher = "Comprehensive R Archive Network (CRAN)",
  filename = NULL,
  overwrite = TRUE
)
}
\arguments{
\item{title}{Software title}

\item{authors}{Character vector of author names}

\item{year}{Publication year}

\item{url}{Software URL (optional)}

\item{version}{Software version (optional)}

\item{doi}{DOI (optional)}

\item{notes}{Additional notes (optional)}

\item{publisher}{Publisher name (default: "Comprehensive R Archive Network (CRAN)")}

\item{filename}{Output file path. If NULL, returns the RIS string without writing to file}

\item{overwrite}{Allow overwriting existing files (default: TRUE)}
}
\value{
Character string with RIS formatted citation, or writes to file if filename provided
}
\description{
Creates a properly formatted RIS citation entry for software packages.
}
\examples{
createRis(
  title = "ggplot2: Create Elegant Data Visualisations",
  authors = c("Wickham, Hadley"),
  year = "2016",
  url = "https://ggplot2.tidyverse.org",
  filename = tempfile() # Omit filename
)

# Write to file
createRis(
  title = "ggplot2: Create Elegant Data Visualisations",
  authors = c("Wickham, Hadley"),
  year = "2016",
  filename = tempfile() # Replace with e.g. "ggplot2.ris"
)
}
