% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climFairRpss.R
\name{climFairRpss}
\alias{climFairRpss}
\title{Calculate Fair Ranked Probability Skill Score Against Climatological
Reference Forecast.}
\usage{
climFairRpss(ens, ens.ref, obs, format = c("category", "member"))
}
\arguments{
\item{ens}{N*K matrix. ens[i,j] is the number of ensemble members that
predict category j at time i.}

\item{ens.ref}{N*K matrix, similar to ens}

\item{obs}{N*K matrix. obs[i,j] = 1 if category j is observed at time i, 0
otherwise.}

\item{format}{additional argument for use with \code{SpecsVerification >= 0.5}.
Do not change this argument manually (except when using \code{climFairRpss},
as standalone function).}
}
\value{
A list with the following elements: \code{rpss|skillscore}: The value of the
skill score. \code{sigma.rpss|skillscore.sd}: The standard deviation of the skill score,
approximated by propagation of uncertainty. Please note that the naming changes with the
new version of \code{SpecsVerification}.
}
\description{
Calculate the fair ranked probability skill score (fair RPSS) between an
ensemble forecasts and a climatological reference forecast derived from the
observations. The categories of the climatological reference forecast have
been defined based on the distribution of the observations and the exact
forecast probabilities are known. The 'fair' correction therefore should not
be applied to the reference forecast.
}
\examples{
tm <- toymodel()

## compute RPSS using veriApply
veriApply("climFairRpss", tm$fcst, tm$obs, prob = 1:2 / 3)

}
\seealso{
\code{\link{veriApply}}
}
