% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkUniqueness2.R
\name{checkUniqueness2}
\alias{checkUniqueness2}
\title{Check uniqueness of a variable.}
\usage{
checkUniqueness2(GADSdat, varName, idVar, impVar)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Single string containing the variable name for which the check should be performed.}

\item{idVar}{Single string containing the name of the identifier variable.}

\item{impVar}{Single string containing the name of the imputation number.}
}
\value{
Returns a logical of length one.
}
\description{
Function to check if a variable is unique for all cases of an identifier variable. This is a fast and more efficient version of
\code{\link{checkUniqueness}} which always returns a logical, non missing value of length one.
}
\details{
For example if missing values are multiple imputed and data is stored in a long format, checking the uniqueness of a variable
within an identifier can be tricky. This function automates this task via reshaping the data into wide format and testing equality
among the reshaped variables. Similar functionality (via matrices) is covered by \code{lme4::isNested},
which is more general and performs similarly.
}
\examples{
## create an example GADSdat
l <- 1000
long_df <- data.table::data.table(id = sort(rep(1:l, 15)),
                               v1 = sort(rep(1:l, 15)),
                                 imp = rep(1:15, l))
gads <- import_DF(long_df)
## check uniqueness
checkUniqueness2(gads, varName = "v1", idVar = "id", impVar = "imp")

}
