% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namesGADS.R
\name{namesGADS}
\alias{namesGADS}
\title{Variables names of a GADS.}
\usage{
namesGADS(GADS)
}
\arguments{
\item{GADS}{A \code{GADSdat} object, a \code{all_GADSdat} or the path to an existing \code{eatGADS} data base.}
}
\value{
Returns a character vector or a named list of character vectors.
}
\description{
Variables names of a \code{GADSdat} object, a \code{all_GADSdat} object or a \code{eatGADS} data base.
}
\details{
If the function is applied to a \code{GADSdat} object, a character vector with all variable names is returned. If the function is
applied to a \code{all_GADSdat} object or to the path of a \code{eatGADS} data base, a named list is returned. Each list entry
represents a data table in the object.
}
\examples{
# Extract variable names from data base
db_path <- system.file("extdata", "pisa.db", package = "eatGADS")
namesGADS(db_path)

# Extract variable names  from loaded/imported GADS
namesGADS(pisa)

}
