% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecdfHT.R
\name{ecdfHT.draw}
\alias{ecdfHT.axes}
\alias{ecdfHT.draw}
\alias{ecdfHT.g}
\alias{ecdfHT.h}
\title{Graph and annotate an ecdfHT plot}
\usage{
ecdfHT.draw(transform.info, x, p, show.plot = TRUE, new.plot = FALSE,
  show.ci = FALSE, xlab = "x", ylab = "", ...)

ecdfHT.axes(transform.info, x.labels = c(), y.labels = c(),
  show.vert.gridlines = FALSE, show.horiz.gridlines = FALSE, ...)

ecdfHT.h(x, t)

ecdfHT.g(p, q)
}
\arguments{
\item{transform.info}{A list with information about the transformation, computed in \code{ecdfHT}}

\item{x}{The data, a vector of double precision numbers.  Assumbed to be sorted and have distinct values.}

\item{p}{Probabilities, a vector of doubles.  Typically p[i]=(i=0.5)/length(x), unless there are repeats in x.}

\item{show.plot}{Boolean value: indicates whether to plot or not.}

\item{new.plot}{Boolean value: indicates whether to produce a new plot or add to an existing plot.}

\item{show.ci}{Boolean value: indicates whether or not confidence intervals are shown.}

\item{xlab}{String to label the horizontal axis.}

\item{ylab}{String to label the vertical axis.}

\item{...}{Optional parameters for the plot, e.g. col='red'.}

\item{x.labels}{Vector of numbers specifying the location of the labels on the horizontal axis}

\item{y.labels}{Vector of numbers specifying the location of the labels on the vertical axis}

\item{show.vert.gridlines}{Boolean value indicating whether or not vertical grid lines should be drawn.}

\item{show.horiz.gridlines}{Boolean value indicating whether or not horizontal grid lines should be drawn.}

\item{t}{A vector of length 3 that specifies the x values that determine the left tail, middle, and right tail}

\item{q}{A vector of length 3 that specifies the quantile values that determine the left tail, middle, and right tail.}
}
\value{
A list of values used in the plot, see return value of \code{ecdfHT}.

\code{ecdfHT.h} returns the vector y=h(x;t), \code{ecdfHT.g} returns the vector y=g(p;q)
}
\description{
Does the computations and plotting for \code{ecdfHT} and can be used to add to an existing plot.
}
\details{
\code{ecdfHT.draw} computes transform and plots.
\code{ecdfHT.axes} draws axes on the plot; it can be used to manually select tick marks, etc.
\code{ecdfHT.h} computes the function h(x) for the transformation of the horizontal axis.
\code{ecdfHT.g} computes the function g(p) for the transformation of the vertical axis.

Always call \code{ecdfHT} first to produce the basic plot, then use \code{ecdfHT.draw}
to add other curves to the plot as in the examples below
}
\examples{
set.seed(1)
x <- rcauchy( 1000 )
t.info <- ecdfHT( x, show.axes=FALSE )
ecdfHT.axes( t.info, x.labels=c(-50,-5,0,5,50), y.labels=c(.001,.01,.1,.5,.9,.99,.999),
  show.vert.gridlines=TRUE, show.horiz.gridline=TRUE, lty=2 )
q1 <- qcauchy(t.info$ecdf) # Cauchy quantiles
ecdfHT.draw( t.info, q1, t.info$ecdf, col='red',show.ci=TRUE)
q2 <- qnorm(t.info$ecdf,sd=sd(x))  # Gaussian quantiles
ecdfHT.draw( t.info, q2, t.info$ecdf, col='green',show.ci=TRUE)
title(paste("simulated Cauchy data, n=",length(x),"\\nred=Cauchy cdf, green=normal cdf"))

x <- seq(-5,5,1)
t <- c(-3,0,3)
ecdfHT.h(x,t)
p <- seq(0.05,.95,.1)
q <- c(.1,.5,.9)
ecdfHT.g(p,q)

}

