% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_power.R
\name{plot_power}
\alias{plot_power}
\alias{plotpower}
\title{Plot Statistical Power and Pseudo-F Distributions}
\usage{
plot_power(
  data,
  cbo = NULL,
  n = NULL,
  m = NULL,
  method = "power",
  completePlot = TRUE
)
}
\arguments{
\item{data}{Object of class \code{"ecocbo_beta"} obtained from \code{\link[=sim_beta]{sim_beta()}}.}

\item{cbo}{Optional. Object of class \code{"cbo_result"} obtained from \code{\link[=sim_cbo]{sim_cbo()}}.
If this is included, \code{plot_power()} uses the optimal values that have been already
calculated.}

\item{n}{Optional. Integer. Number of samples \code{n} within the selected \code{m}.
Defaults to \code{NULL}, and the function selects the number of samples yielding a
power close to \eqn{1 - \alpha}.}

\item{m}{Optional. Integer. Number of replicates \code{m} to use for power computation.
Defaults to \code{NULL}, in which case the function selects the number of sites that
result in a sampling effort that is close to \eqn{1 - \alpha}.}

\item{method}{Character. Type of plot to generate:
\itemize{
\item "power": Plots the power curve.
\item "density": Plots the density distribution of pseudo-F values.
\item "both": Displays both plots side by side.
\item "surface": Displays a 3d surface plot of the power curves for nested
factors experiments.
}}

\item{completePlot}{Logical. Is the plot to be drawn complete? If TRUE the
plot will be trimmed to present a better distribution of the density plot.}
}
\value{
A plot displaying:
\itemize{
\item If \code{method = "power"}, power curves for different values of \code{m}, with the
selected \code{n} highlighted in red.
\item If \code{method = "density"}: a density plot of observed pseudo-F values with
a vertical line indicating significance from \code{\link[=sim_beta]{sim_beta()}}.
\item If \code{method = "both"}: a composite figure with both the power curve and the
density plot.
\item If \code{method = "surface"}: a surface plot for the statistical power in different
sampling designs.
}

The selected values of \code{m}, \code{n}, and the corresponding component of variation
are displayed in all cases.
}
\description{
Visualizes the statistical power of a study as a function of the sampling effort.
The power curve plot illustrates how power increases with sample size, while
the density plot highlights overlapping areas where \eqn{\alpha} and
\eqn{\beta} are significant.
}
\examples{
# Power curve visualization
plot_power(data = epiBetaR, method = "power")

# Density plot of pseudo-F values
plot_power(data = betaNested, method = "density")

# Composite plot with both power curve and density plot
plot_power(data = betaNested, method = "both")

}
\references{
\itemize{
\item Underwood, A. J. (1997). Experiments in ecology: their logical
design and interpretation using analysis of variance. Cambridge university
press.
\item Underwood, A. J., & Chapman, M. G. (2003). Power, precaution,
Type II error and sampling design in assessment of environmental impacts.
Journal of Experimental Marine Biology and Ecology, 296(1), 49-70.
}
}
\seealso{
\code{\link[=sim_beta]{sim_beta()}}
\code{\link[=scompvar]{scompvar()}}
\code{\link[=sim_cbo]{sim_cbo()}}
\code{\link[=prep_data]{prep_data()}}
}
\author{
Edlin Guerra-Castro (\email{edlinguerra@gmail.com}), Arturo Sanchez-Porras
}
