% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{eode_sensitivity_proj}
\alias{eode_sensitivity_proj}
\title{Sensitivity Analysis}
\usage{
eode_sensitivity_proj(x, valueSpace, N, step = 0.01)
}
\arguments{
\item{x}{object of class "\code{pc}" that represents the ODE system under
consideration.}

\item{valueSpace}{a list indicating initial conditions and parameters. Model
variables must be included to specify initial values of each variable. Values
can be a vector, indicating all the potential values to be considered in the
sensitivity analysis.}

\item{N}{number of iterations}

\item{step}{interval of time for running simulations. Parameter of the function "\code{eode_proj()}".}
}
\value{
an object of "\code{pcfamily}" class, each component having three
sub-components:
\code{$grid_var}: variables or parameters whose values are changed throughout
the sensitivity analysis.
\code{$fixed_var}: variables whose values are not changed.
\code{$pc}: phase curve. An object of "\code{pc}" class.
}
\description{
Run a sensitivity analysis on an ODE system.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2, constraint = c("x<100", "y<100"))
eode_sensitivity_proj(x, valueSpace = list(x = c(0.2, 0.3, 0.4), y = 0.1, a11 = 1:3), N = 100)
}
